<?php
/* --------------------------------------------------------------
   ClearedCache.php 2020-04-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Cache\Events;

use Gambio\Core\Cache\Exceptions\InvalidArgumentException;

/**
 * Class ClearedCache
 *
 * @package Gambio\Core\Cache\Events
 */
class ClearedCache
{
    /**
     * @var string
     */
    private $namespace;
    
    
    /**
     * ClearedCache constructor.
     *
     * @param string $namespace
     */
    private function __construct(string $namespace)
    {
        $this->namespace = $namespace;
    }
    
    
    /**
     * @param string $namespace
     *
     * @return ClearedCache
     *
     * @throws InvalidArgumentException
     */
    public static function create(string $namespace): ClearedCache
    {
        if (strlen($namespace) > 64 || preg_match('/^[A-Za-z0-9_\.]+$/', $namespace) !== 1) {
            throw InvalidArgumentException::forNamespace();
        }
        
        return new self($namespace);
    }
    
    
    /**
     * @return string
     */
    public function namespace(): string
    {
        return $this->namespace;
    }
}